
/*************************************************************************
 *           Copyright (C) 2003 by Freescale.  All rights reserved.      *
 *************************************************************************
 *                                                                       *
 *   Freescale reserves the right to make changes without further notice *
 *   to any product herein to improve reliability, function or design.   *
 *   Freescale does not assume any liability arising out of the          *
 *   application or use of any product, circuit, or software described   *
 *   herein; neither does it convey any license under its patent rights  *
 *   nor the rights of others.                                           *
 *                                                                       *
 *   Freescale products are not designed, intended, or authorized for    *
 *   use as components in systems intended for surgical implant into     *
 *   the body, or other applications intended to support life, or for    *
 *   any other application in which the failure of the Freescale product *
 *   could create a situation where personal injury or death may occur.  *
 *                                                                       *
 *   Should Buyer purchase or use Freescale products for any such        *
 *   unintended or unauthorized application, Buyer shall idemnify and    *
 *   hold Freescale and its officers, employees, subsidiaries,           *
 *   affiliates, and distributors harmless against all claims costs,     *
 *   damages, and expenses, and reasonable attorney fees arising out     *
 *   of, directly or indirectly, any claim of personal injury or death   *
 *   associated with such unintended or unauthorized use, even if such   *
 *   claim alleges that Freescale was negligent regarding the design     *
 *   or manufacture of the part.                                         *
 *                                                                       *
 *   Freescale and the Freescale logo* are registered trademarks of      *
 *   Freescale Ltd.                                                      *
 *                                                                       *
 *************************************************************************

 *************************************************************************
 *                                                                       *
 *                Freescale's H7F Flash Memory for MPC55xx               *
 * 																		 *
 *                                                                       *
 * FILE NAME     :  censorship_recovery.c                          		 *
 * VERSION:      :  1.00                                                 *
 * DATE          :  June 12, 2008                                        *
 * INFO			 : 	Uses custom code to erase & restore shadow blk info  *
 *                                                                       *
 *************************************************************************/

/************************ Revision History *******************************
 0.1	David connelly 	06-12-08		- Initial Release.
 *************************************************************************/

#include "m_h7f.h"

#define W32(addr, value)  	(*((volatile unsigned int *) (addr)) = (value))		//write 32 bits of data
#define FLASH               (*( struct H7F_tag *) 0xC3F88000)      				//point to flash registers (0xFFFF8000 for MPC551x)

#define SHADOW_ADDRESS		0x00FFFC00 
#define CENSORSHIP_ADDR		0x00FFFDE0
#define SERIAL_BOOT1_ADDR	0x00FFFDD8
#define SERIAL_BOOT2_ADDR	0x00FFFDDC
#define SERIAL_PASSWORD1	0xFEEDFACE
#define SERIAL_PASSWORD2	0xCAFEBEEF
#define LOW_ADDR_KEY		0xA1A11111
#define S_LOW_ADDR_KEY		0xC3C33333
#define LOW_ADDR_SR_UNLOCK	0x800FFFFF 

void main(void)
{
	/* enable shadow space */			
	FLASH.LML.R = LOW_ADDR_KEY;
	FLASH.LML.R = LOW_ADDR_SR_UNLOCK;
	FLASH.SLL.R = S_LOW_ADDR_KEY;
	FLASH.SLL.R = LOW_ADDR_SR_UNLOCK;

	/* step1. erase shadow row */				  
	FLASH.MCR.B.ERS = 1;
	W32(SHADOW_ADDRESS, 0x0);	  			//interlock write
	FLASH.MCR.B.EHV = 1;
	while (FLASH.MCR.B.DONE==0);
	FLASH.MCR.B.EHV = 0;						//clear EHV
	FLASH.MCR.B.ERS = 0;   						//clear ERS
 
	/* step2. program the serial boot word */   
	FLASH.MCR.B.PGM = 1;
	W32(SERIAL_BOOT1_ADDR, SERIAL_PASSWORD1);	//interlock write
	W32(SERIAL_BOOT2_ADDR, SERIAL_PASSWORD2);	//interlock write
	FLASH.MCR.B.EHV = 1;
	while (FLASH.MCR.B.DONE==0) ;   
	FLASH.MCR.B.EHV = 0;	  					//clear EHV
	FLASH.MCR.B.PGM = 0;	  					//clear PGM
  
	/* step3. program the censorship control word  */  
	FLASH.MCR.B.PGM = 1;
	W32(CENSORSHIP_ADDR, 0x55aa55aa);	  		//interlock write
	W32(CENSORSHIP_ADDR+4, 0xffffffff);	  		//interlock write
	FLASH.MCR.B.EHV = 1;
	while (FLASH.MCR.B.DONE==0);   
	FLASH.MCR.B.EHV = 0;	  					//clear EHV
	FLASH.MCR.B.PGM = 0;	  					//clear PGM
	
	while(1);
}